#include "SD320.h"

#ifdef _SD320_H_
void SD320::setup(void)
{
	// Настраиваем SPI пин chipSelect на пин
	SPI_Master.begin(SPI_ArduinoMaster_ChipSelectPin);

	// Инициализируем экземпляр класса SD320_Command как для мастера
	command.InitForMaster();
}

// Отправляет сформированную команду и ждет в ответ CommandDone
void SD320::SendCommandAndWaitForCommandDoneResponse(uint8_t* arrPointer)
{
	// Обработка ситуации если указатель на отправляемый массив равен NULL (jMove, jMoveTo)
	if(arrPointer == NULL)
	{
		return;
	}

	uint8_t i;
	uint8_t arrSize = arrPointer[2];
	uint32_t ResponseTimeoutTime;

	#ifdef DEBUG
		Serial.print("Sending array: ");
		for (i = 0; i < arrSize; i++)
		{
			Serial.print(arrPointer[i], HEX);
			Serial.print("\t");
		}
		Serial.println("");
		Serial.print("arrSize: ");
		Serial.println(arrSize);
	#endif

	command.CommandDoneFlag = false;
	#ifdef DEBUG
		Serial.print("command.CommandDoneFlag: ");
		Serial.println(command.CommandDoneFlag);
	#endif
	do
	{
		// Отправляем до тех пор пока не получится
	sending:
		#ifdef DEBUG
				Serial.println("Отправляем ...");
		#endif
				while (!SPI_Master.SendBytes(arrPointer, arrSize));
		#ifdef DEBUG
				Serial.println("Отправлено!");
		#endif


		// Ждем ответ в виде CommandDone
		#ifdef DEBUG
				Serial.println("Ждем ответа ...");
		#endif
				ResponseTimeoutTime = millis();
				do
				{
				} while (!SPI_Master.ReceiveBytes(rx, &rx_PacketLength));
				if (SPI_Master.DesyncFlag)
				{
					goto sending;
				}
		#ifdef DEBUG
				Serial.println("Ответ получен!");
		#endif

		// Обрабатываем пакет 
		command.HandlePacket(rx);

		#ifdef DEBUG
				Serial.print("command.CommandDoneFlag: ");
				Serial.println(command.CommandDoneFlag);

				if (!command.CommandDoneFlag)
					Serial.println("Пакет не обработан");
		#endif
	}
	// Проверяем выполнена ли команда
	while (!command.CommandDoneFlag);
}
#endif
