/*
 * Класс-обертка для mBlock
 *
 * ver. 1.0.0.0 - Создание класса
 * ver. 1.0.0.1 - Инициализация серийного порта перенесена в функцию setup().
 *				- Инициализация серийного порта и вывод отладочной информации происходит только при объявлении DEBUG
 * 2021_01_26 v1.0.0.2 - Подправлена логика функции SendCommandAndWaitForCommandDoneResponse: Если после отправки заданного пакета ответ не был получен в течение 3сек, то заданный пакет отправляется снова и ожидается ответ. И так до тех пор пока ответ не будет получен корректно.
 * 2021_02_05 v1.0.0.3 - Реализовано резрешение проблемы рассинхронизации
 * 2021_12_01 v1.0.1.0 - SD320_Command v1.0.9.0: Добавлена проверка валидности углов при использовани команд jMove и jMoveTo
 * 					   - Удалены скрытые символы, мешавшие компиляции в новой версии Arduino IDE
 */
#ifdef ARDUINO

//#define DEBUG

#ifndef _SD320_H_
	#define _SD320_H_
	#include <Arduino.h>
	#include "SPI_ArduinoMaster.h" // Библиотека интерфейса передачи данных по SPI
	#include "SD320_Command.h" // Библиотека интерфейса формирования команд

	// SPI пин chipSelect
	#define SPI_ArduinoMaster_ChipSelectPin A8

	class SD320
	{
	public:
		// Интерфейс передачи данных по SPI
		SPI_ArduinoMaster SPI_Master;

		// Интерфейс формирования команд
		SD320_Command command;

		uint8_t rx[255];
		uint8_t rx_PacketLength;

		void setup(void);

		void SendCommandAndWaitForCommandDoneResponse(uint8_t* arrPointer);
	};
#endif

#endif
